﻿using System.Collections.Generic;
using System.Web.UI;
using System;

namespace Controls
{
    public class ErrorHandler : ScriptControl
    {
        protected override IEnumerable<ScriptReference> GetScriptReferences()
        {
            yield return new ScriptReference("Controls.JavaScript.ErrorHandler.js", typeof(ErrorHandler).Assembly.FullName);
        }

        protected override IEnumerable<ScriptDescriptor> GetScriptDescriptors()
        {
            //ScriptComponentDescriptor scd = new ScriptComponentDescriptor("ErrorHandler");
            //scd.ID = "ErrorHandler";
            //yield return scd;
            return null;
        }

        protected override void OnPreRender(EventArgs e)
        {
            base.OnPreRender(e);
            string createErrorHandler = @"
            Sys.Application.add_init(
              function() { 
                var errHandler = $find('ErrorHandler');
                if (errHandler === null) {
                  $create(ErrorHandler, {id:'ErrorHandler'}, null, null, null); 
                }
              }
            );
            ";
            ScriptManager.RegisterStartupScript(this, typeof(ErrorHandler), "ErrorHandlerCreate", createErrorHandler, true);
        }
    }
}